/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.electricity;

import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.electricity.Connection;
import com.mrcrayfish.furniture.refurbished.electricity.ElectricityTicker;
import com.mrcrayfish.furniture.refurbished.electricity.ISourceNode;
import com.mrcrayfish.furniture.refurbished.util.BlockEntityHelper;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_7225;

public interface IElectricityNode {
    public class_2338 getNodePosition();

    public class_1937 getNodeLevel();

    public class_2586 getNodeOwner();

    public class_238 getNodeInteractBox();

    public boolean isSourceNode();

    public boolean isNodePowered();

    public void setNodePowered(boolean var1);

    public Set<Connection> getNodeConnections();

    public void setNodeReceivingPower(boolean var1);

    public Set<class_2338> getPowerSources();

    default public boolean isNodeInPowerableNetwork() {
        return !this.getPowerSources().isEmpty();
    }

    default public boolean isNodeInPowerableNetwork(class_2338 source) {
        return this.getPowerSources().contains(source);
    }

    public boolean isNodeReceivingPower();

    default public boolean isNodeValid() {
        return !this.getNodeOwner().method_11015();
    }

    default public void onNodeDestroyed() {
        this.removeAllNodeConnections();
    }

    default public void onNodeConnectedTo(IElectricityNode other) {
    }

    default public boolean canPowerTraverseNode() {
        return true;
    }

    default public Set<Connection> updateAndGetNodeConnections() {
        this.updateNodeConnections();
        return this.getNodeConnections();
    }

    default public void syncDataToTrackingClients() {
        class_2586 entity = this.getNodeOwner();
        BlockEntityHelper.sendCustomUpdate(entity, class_2586::method_16887);
    }

    default public void readNodeNbt(class_2487 tag) {
        if (tag.method_10573("Connections", 12)) {
            long[] nodes;
            class_2338 previous;
            class_2338 current;
            class_2338 offset = class_2338.field_10980;
            if (tag.method_10573("NodePos", 4) && !(current = this.getNodePosition()).equals((Object)(previous = class_2338.method_10092((long)tag.method_10537("NodePos"))))) {
                offset = current.method_10059((class_2382)previous);
            }
            class_2338 pos = this.getNodePosition();
            Set<Connection> connections = this.getNodeConnections();
            connections.clear();
            for (long node : nodes = tag.method_10565("Connections")) {
                connections.add(Connection.of(pos, class_2338.method_10092((long)node).method_10081((class_2382)offset)));
            }
        }
    }

    default public void writeNodeNbt(class_2487 tag) {
        Set<Connection> connections = this.getNodeConnections();
        tag.method_10538("Connections", connections.stream().map(Connection::getPosB).map(class_2338::method_10063).toList());
        tag.method_10544("NodePos", this.getNodePosition().method_10063());
    }

    default public void saveNodeNbtToItem(class_1799 stack, class_7225.class_7874 provider) {
        class_2586 entity = this.getNodeOwner();
        class_2487 tag = entity.method_38244(provider);
        tag.method_10551("Connections");
        tag.method_10551("NodePos");
        tag.method_10551("Powered");
        tag.method_10551("Overloaded");
        class_1747.method_57338((class_1799)stack, (class_2591)entity.method_11017(), (class_2487)tag);
    }

    default public void removeNodeConnection(Connection connection) {
        if (this.getNodeConnections().remove(connection)) {
            this.syncDataToTrackingClients();
            this.getNodeOwner().method_5431();
        }
    }

    default public void removeAllNodeConnections() {
        Set<Connection> connections = this.getNodeConnections();
        connections.forEach(c -> {
            IElectricityNode node = c.getOtherNode(this);
            if (node != null && node.isNodeValid()) {
                node.removeNodeConnection((Connection)c);
                node.syncDataToTrackingClients();
            }
        });
        connections.clear();
        this.getNodeOwner().method_5431();
    }

    default public void updateNodeConnections() {
        class_1937 level = this.getNodeLevel();
        this.getNodeConnections().removeIf(c -> {
            if (!c.isConnected(level)) {
                IElectricityNode node = c.getOtherNode(this);
                if (node != null) {
                    node.removeNodeConnection((Connection)c);
                }
                return true;
            }
            return false;
        });
    }

    default public int getNodeMaximumConnections() {
        return (Integer)Config.SERVER.electricity.maximumLinksPerElectricityNode.get();
    }

    default public boolean isNodeConnectionLimitReached() {
        return this.getNodeConnections().size() >= this.getNodeMaximumConnections();
    }

    default public boolean connectToNode(IElectricityNode other) {
        class_2338 pos = this.getNodePosition();
        Set<Connection> connections = this.getNodeConnections();
        if (connections.add(Connection.of(pos, other.getNodePosition()))) {
            other.connectToNode(this);
            this.onNodeConnectedTo(other);
            this.syncDataToTrackingClients();
            this.getNodeOwner().method_5431();
            return true;
        }
        return false;
    }

    default public boolean isConnectedToNode(IElectricityNode node) {
        Set<Connection> connections = this.getNodeConnections();
        return connections.contains(Connection.of(this.getNodePosition(), node.getNodePosition()));
    }

    default public class_238 getPositionedNodeInteractBox() {
        return this.getNodeInteractBox().method_996(this.getNodePosition());
    }

    default public void registerElectricityNodeTicker(class_1937 level) {
        ElectricityTicker.get(level).addElectricityNode(this);
    }

    default public void earlyNodeTick(class_1937 level) {
    }

    public static List<IElectricityNode> searchNodes(IElectricityNode start) {
        return IElectricityNode.searchNodes(start, (Integer)Config.SERVER.electricity.maximumNodesInNetwork.get(), false, node -> true, node -> true);
    }

    public static List<IElectricityNode> searchNodes(IElectricityNode start, int searchLimit, boolean cancelAtLimit, Predicate<IElectricityNode> searchPredicate, Predicate<IElectricityNode> matchPredicate) {
        class_238 box = ISourceNode.createPowerableZone(start.getNodeLevel(), start.getNodePosition());
        HashSet<IElectricityNode> found = new HashSet<IElectricityNode>(List.of(start));
        ArrayDeque<IElectricityNode> queue = new ArrayDeque<IElectricityNode>(searchLimit);
        queue.add(start);
        block0: while (!queue.isEmpty()) {
            IElectricityNode node = (IElectricityNode)queue.poll();
            for (Connection connection : node.getNodeConnections()) {
                class_2338 pos;
                IElectricityNode other = connection.getNodeB(node.getNodeLevel());
                if (other == null || found.contains(other) || !box.method_1008((double)(pos = other.getNodePosition()).method_10263(), (double)pos.method_10264(), (double)pos.method_10260())) continue;
                found.add(other);
                if (cancelAtLimit && found.size() >= searchLimit) break block0;
                if (!searchPredicate.test(other)) continue;
                queue.add(other);
            }
        }
        return found.stream().filter(matchPredicate).collect(Collectors.toList());
    }
}

